<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"
xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
xmlns="http://www.w3.org/1999/xhtml">

<xsl:output
	method="html"
	encoding="UTF-16"
	doctype-public="-//W3C//DTD XHTML 1.1//EN"
	doctype-system="http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd"
	indent="yes"
	cdata-section-elements="style script"/>

<xsl:template match="/root">
	<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
	<head>
		<meta http-equiv="content-type" content="text/html; charset=utf-16" />
		<link rel="stylesheet" href="../css/default.css" type="text/css" media="all" charset="utf-8" />
		<link rel="stylesheet" href="../css/overview_section.css" type="text/css" media="all" charset="utf-8" />
		<link rel="stylesheet" href="../css/category_explorer.css" type="text/css" media="all" charset="utf-8" />
		<link rel="stylesheet" href="../css/zero_states.css" media="all" charset="utf-8" type="text/css" />

        <script type="text/javascript" src="../js/jquery-1.10.2.js" charset="utf-8"></script>
		<script type="text/javascript" src="../js/categoryExplorer.js" charset="utf-8"></script>
		<script type="text/javascript" src="../js/spendingTrends.js" charset="utf-8"></script>
		<script type="text/javascript" src="../js/deferredPrinting.js" charset="utf-8"></script>
		<script type="text/javascript" src="../js/utils.js" charset="utf-8"></script>
        <script type="text/javascript" src="../js/highcharts.js" charset="utf-8"></script>
		<script type="text/javascript">
$(CategoryExplorerInit);
		</script>
	</head>
	
	<body id="categoryExplorer">
		<div id="outerWrapper">
		
			<div id="innerWrapper">
				<xsl:apply-templates select="currencies"/>
                <h1 id="pageTitle"></h1>

				<!--<div id="totalSpentAmount"><xsl:value-of select="@transactionTotal"/></div>-->
                <!-- xsl:if test="count(@transactionCount)">
                    <div class="transaction_details">
                        <span><xsl:value-of select="@transactionCount"/> items </span>
                        <span>(<xsl:value-of select="@transactionTotal"/>)</span>
                    </div>
                </xsl:if -->
				<div id="stepACont" class="clearAfter section">
					<xsl:apply-templates select="spendingTrendsDates"/>
					<xsl:call-template name="MainSummary"/>
					
					<xsl:choose>
				
						<!-- Do we have any accounts? -->
						<xsl:when test="count(/root/plotData/*)">
							<!-- Pie Plot -->
							<xsl:apply-templates select="plotData"/>
						</xsl:when>
					
						<!-- No accounts present -->
						<xsl:otherwise>
							<xsl:call-template name="SpendingTrendsEmpty"/>
						</xsl:otherwise>
					
					</xsl:choose>
				</div>
			</div>
		</div>
	</body>
	</html>
</xsl:template>

<!-- Main Summary -->

<xsl:template name="MainSummary">
	<div id="mainSummary">
		<div id="totalSpent">
			<span class="moneySpent"><xsl:value-of select="@transactionTotal"/></span>
			<span class="dateRange"><xsl:value-of select="@dateRange"/></span>
		</div>
		<xsl:if test="count(@transactionCount)">
			<div class="row">
				<span class="label">Transactions:</span>
				<span class="data"><xsl:value-of select="@transactionCount"/></span>
			</div>
		</xsl:if>
		<xsl:if test="count(@percentOfTotal)">
			<div class="row">
				<span class="label">% of Total <xsl:value-of select="@reportType"/>:</span>
				<span class="data"><xsl:value-of select="@percentOfTotal"/>%</span>
			</div>
		</xsl:if>
		<xsl:choose>
			<xsl:when test="number(@uncategorizedCount) > 1">
				<div class="summaryMsg warning">
					<a class="uncatLink moretrnx" href="" title="Show Uncategorized Transactions">
					<p><xsl:value-of select="@uncategorizedCount"/> uncategorized transactions totaling <xsl:value-of select="@uncategorizedTotal" /></p></a>
				</div>
			</xsl:when>
			<xsl:when test="number(@uncategorizedCount) = 1">
				<div class="summaryMsg warning">
					<a class="uncatLink onetrnx" href="" title="Show Uncategorized Transactions">
					<p>1 uncategorized transaction totaling <xsl:value-of select="@uncategorizedTotal" /></p></a>
				</div>
			</xsl:when>
		</xsl:choose>
	</div>
</xsl:template>


<!-- Currencies -->

<xsl:template match="currencies">
	<xsl:if test="count(currency) > 1">
		<select id="currencyTypeSelect">
			<xsl:apply-templates select="currency"/>
		</select>
	</xsl:if>
</xsl:template>


<xsl:template match="currency">
	<xsl:choose>
		<xsl:when test="@selected='YES'">
			<option value="{@currencyID}" selected=""><xsl:value-of select="@title"/></option>
		</xsl:when>
		<xsl:otherwise>
			<option value="{@currencyID}"><xsl:value-of select="@title"/></option>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>


<!-- Spending Trends Part -->

<xsl:template match="spendingTrendsDates">
	<select id="timeFrameSelect">
		<xsl:apply-templates select="option"/>
	</select>
</xsl:template>


<xsl:template match="spendingTrendsDates/option">
	<xsl:choose>
		<xsl:when test="@value='currentMonth'">
			<option value="{@value}">
				<xsl:if test="@selected='YES'"><xsl:attribute name="selected"/></xsl:if>
				Month to Date (<xsl:value-of select="../@currentMonthName"/>)
			</option>
		</xsl:when>
		<xsl:when test="@value='lastMonth'">
			<option value="{@value}">
				<xsl:if test="@selected='YES'"><xsl:attribute name="selected"/></xsl:if>
				Last Month (<xsl:value-of select="../@lastMonthName"/>)
			</option>
		</xsl:when>
		<xsl:when test="@value='lastSixMonths'">
			<option value="{@value}">
				<xsl:if test="@selected='YES'"><xsl:attribute name="selected"/></xsl:if>
				Last 6 Months
			</option>
		</xsl:when>
		<xsl:when test="@value='last12Months'">
			<option value="{@value}">
				<xsl:if test="@selected='YES'"><xsl:attribute name="selected"/></xsl:if>
				Last 12 Months
			</option>
		</xsl:when>
		<xsl:when test="@value='yearToDate'">
			<option value="{@value}">
				<xsl:if test="@selected='YES'"><xsl:attribute name="selected"/></xsl:if>
				Year to Date
			</option>
		</xsl:when>
		<xsl:otherwise>
			<option value="{@value}">
				<xsl:if test="@selected='YES'"><xsl:attribute name="selected"/></xsl:if>
				Last Month (<xsl:value-of select="../@lastMonthName"/>)
			</option>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>


<xsl:template match="plotData">
    <div id="spendingTrendsPlot" style="width: 400px; height: 260px; margin: 0 auto; display: block; float: left;"/>

	<div class="stepAContent">
		<!-- <div class="totalSpending">Total Spending<br /><xsl:value-of select="@rangeString"/></div> -->
		<!-- <div class="totalAmount"><xsl:value-of select="total"/></div> -->
		<div id="tableMask">
			<div id="tableHolder"></div>
		</div>
	</div>
			
	<div class="spendingTrendsKey">
		<xsl:attribute name="id"><xsl:value-of select="@graphType"/></xsl:attribute>
		<xsl:apply-templates select="payee"/>
		<xsl:apply-templates select="negativePayee"/>
	</div>
    
    <!-- Spending Trend Details -->
    <div id="spendingTrendsDetails">
        <div id="spendingTotal">$1,108</div>
        <div id="spendingFilter">Month to Date</div>
        <div id="uncategorizedTrnx"></div>
        <div id="uncategorizedTotal"></div>
    </div>

</xsl:template>


<xsl:template match="payee">
	<div class="payee">
		<span class="category"><xsl:value-of select="category"/></span>
		<span class="rawAmount"><xsl:value-of select="rawAmount"/></span>
		<span class="percentage"><xsl:value-of select="percentage"/>%</span>
		<span class="quickenID"><xsl:value-of select="quickenID"/></span>
		<span class="numberOfTxn"><xsl:value-of select="numberOfTxn"/></span>

		<xsl:choose>
			<xsl:when test="amount[@sign='negative']">
				<span class='amount negative'><xsl:value-of select="amount"/></span>
			</xsl:when>
			<xsl:otherwise>
				<span class='amount'><xsl:value-of select="amount"/></span>
			</xsl:otherwise>
		</xsl:choose>
	</div>
</xsl:template>

<xsl:template match="negativePayee">
	<div class="negativePayee">
		<span class="category"><xsl:value-of select="category"/></span>
		<span class="rawAmount"><xsl:value-of select="rawAmount"/></span>
		<span class="percentage"><xsl:value-of select="percentage"/>%</span>
		<span class="quickenID"><xsl:value-of select="quickenID"/></span>
		<span class="numberOfTxn"><xsl:value-of select="numberOfTxn"/></span>

		<xsl:choose>
			<xsl:when test="amount[@sign='negative']">
				<span class='amount negative'><xsl:value-of select="amount"/></span>
			</xsl:when>
			<xsl:otherwise>
				<span class='amount'><xsl:value-of select="amount"/></span>
			</xsl:otherwise>
		</xsl:choose>
	</div>
</xsl:template>


<!-- No Spending Trend Payees -->

<xsl:template name="SpendingTrendsEmpty">
	<div class="noDataA">
		<xsl:choose>
			<xsl:when test="number(@uncategorizedCount) > 1">
				<p class="first">You have <xsl:value-of select="@uncategorizedCount"/> uncategorized transactions for the current filter settings.</p>
				<div class="second moretrnxAnchor">Click here to see them.</div>
			</xsl:when>
			<xsl:when test="number(@uncategorizedCount) = 1">
				<p class="first">You have 1 uncategorized transaction for the current filter settings.</p>
				<div class="second onetrnxAnchor">Click here to see it.</div>
			</xsl:when>
			<xsl:otherwise>
				<p class="first">You have no transactions for the current filter settings.</p>
				<p class="second">Try adjusting the filters above.</p>
			</xsl:otherwise>
		</xsl:choose>
	</div>
</xsl:template>

</xsl:stylesheet>
